<?php

namespace App\Models\Events;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EventRealization extends Model 
{

    protected $table = 'event_realizations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('public');

    public function getFacts()
    {
        return $this->belongsTo('EventFacts');
    }

    public function getAttendances()
    {
        return $this->hasMany('Attandance');
    }

    public function getChallengeElements()
    {
        return $this->hasMany('ChallengeElement');
    }

}